/*                                                                          */
/*  File:      ConsoleFlat.cpp                                              */
/*  Function:  DLL with flat functions for Console class - demo for article */
/*             http://rvelthuis.de/articles/articles-cppobjs.html           */
/*  Language:  C++ (C++Builder 2007)                                        */
/*  Author:    Rudy Velthuis                                                */
/*  Copyright: (c) 2012 Rudy Velthuis. All rights reserved.                 */
/*  Disclaimer:                                                             */
/*                                                                          */
/*    Redistribution and use in source and binary forms, with or            */
/*    without modification, are permitted provided that the following       */
/*    conditions are met:                                                   */
/*                                                                          */
/*    - Redistributions of source code must retain the above copyright      */
/*      notice, this list of conditions and the following disclaimer.       */
/*    - Redistributions in binary form must reproduce the above copyright   */
/*      notice, this list of conditions and the following disclaimer in	    */
/*      the documentation and/or other materials provided with the          */
/*      distribution.                                                       */
/*    - Neither the name of this code nor the names of its                  */
/*      contributors may be used to endorse or promote products derived	    */
/*      from this software without specific prior written permission.       */
/*                                                                          */
/*    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND                */
/*    CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,           */
/*    INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF              */
/*    MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE                  */
/*    ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR	            */
/*    CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,          */
/*    SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,              */
/*    BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;      */
/*    LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER      */
/*    CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT    */
/*    LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING        */
/*    IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF        */
/*    THE POSSIBILITY OF SUCH DAMAGE.                                       */
/*                                                                          */

#include <windows.h>
#include "console.h"

typedef Console *ConsoleHandle;

// define a macro for the calling convention and export type
#define EXPORTCALL __declspec(dllexport) __stdcall

extern "C"
{

    ConsoleHandle EXPORTCALL NewConsole(void)
    {
        return new Console();
    }

    void EXPORTCALL DeleteConsole(ConsoleHandle handle)
    {
        delete handle;
    }

    void EXPORTCALL ConsoleReset(ConsoleHandle handle)
    {
        handle->reset();
    }

    void EXPORTCALL ConsoleClearScreen(ConsoleHandle handle)
    {
        handle->clearScreen();
    }

    void EXPORTCALL ConsoleGotoXY(ConsoleHandle handle, int x, int y)
    {
        handle->gotoXY(x, y);
    }

    void EXPORTCALL ConsoleTextColor(ConsoleHandle handle, TextColors newColor)
    {
        handle->textColor(newColor);
    }

    void EXPORTCALL ConsoleTextAttribute(ConsoleHandle handle, int newAttribute)
    {
        handle->textAttribute(newAttribute);
    }

    void EXPORTCALL ConsoleTextBackground(ConsoleHandle handle, int newBackground)
    {
        handle->textBackground(newBackground);
    }

    int EXPORTCALL ConsoleReadKey(ConsoleHandle handle)
    {
        return handle->readKey();
    }

    bool EXPORTCALL ConsoleKeyPressed(ConsoleHandle handle)
    {
        return handle->keyPressed();
    }

    void EXPORTCALL ConsoleWrite(ConsoleHandle handle, const char *text)
    {
        handle->write(text);
    }

    void EXPORTCALL ConsoleWriteLn(ConsoleHandle handle, const char *text)
    {
        handle->writeLn(text);
    }

} // extern "C"

#pragma argsused
int WINAPI DllEntryPoint(HINSTANCE hinst, unsigned long reason, void* lpReserved)
{
    return 1;
}

