unit ConsoleFlat;

interface

type
  // Can't use the class directly, so it is treated as an opaque handle.
  ConsoleHandle = THandle;

  TTextColor = (
    tcBLACK,
    tcBLUE,
    tcGREEN,
    tcCYAN,
    tcRED,
    tcMAGENTA,
    tcBROWN,
    tcLIGHTGRAY,
    tcDARKGRAY,
    tcLIGHTBLUE,
    tcLIGHTGREEN,
    tcLIGHTCYAN,
    tcLIGHTRED,
    tcLIGHTMAGENTA,
    tcYELLOW,
    tcWHITE
  );

function NewConsole: ConsoleHandle; stdcall; 
procedure DeleteConsole(handle: ConsoleHandle); stdcall;
procedure ConsoleReset(handle: ConsoleHandle); stdcall;
procedure ConsoleClearScreen(handle: ConsoleHandle); stdcall;
procedure ConsoleGotoXY(handle: ConsoleHandle; 
  x, y : Integer); stdcall;
procedure ConsoleTextColor(handle: ConsoleHandle; 
  newColor: TTextColor); stdcall;
procedure ConsoleTextAttribute(handle: ConsoleHandle;
  newAttribute: Integer); stdcall;
procedure ConsoleTextBackground(handle: ConsoleHandle; 
  newBackground: TTextColor); stdcall;
function ConsoleReadKey(handle: ConsoleHandle): Integer; stdcall;
function ConsoleKeyPressed(handle: ConsoleHandle): Boolean; stdcall;
procedure ConsoleWrite(handle: ConsoleHandle; text: PAnsiChar); stdcall;
procedure ConsoleWriteLn(handle: ConsoleHandle; text: PAnsiChar); stdcall;

implementation

const
  DLLName = 'ConsoleFlat.dll';

function NewConsole; external DLLName; 
procedure DeleteConsole; external DLLName;
procedure ConsoleReset; external DLLName;
procedure ConsoleClearScreen; external DLLName;
procedure ConsoleGotoXY; external DLLName;
procedure ConsoleTextColor; external DLLName;
procedure ConsoleTextAttribute; external DLLName;
procedure ConsoleTextBackground; external DLLName;
function ConsoleReadKey; external DLLName;
function ConsoleKeyPressed; external DLLName;
procedure ConsoleWrite; external DLLName;
procedure ConsoleWriteLn; external DLLName;

end.


