program ConsoleFlatTest;

{$APPTYPE CONSOLE}

uses
  SysUtils,
  ConsoleFlat in 'ConsoleFlat.pas';

var
  Console: ConsoleHandle;

begin
  Writeln('Using ConsoleFlat - ConsoleXXX functions');
  Writeln;
  Writeln('This is just some text.');
  Writeln('This is just some different text.');
  Writeln('Now creating Console object.');
  Console := NewConsole;
  try
    ConsoleWrite(Console, 'press any key...');
    ConsoleReadKey(Console);
    ConsoleTextBackground(Console, tcRED);
    ConsoleClearScreen(Console);
    ConsoleTextColor(Console, tcYELLOW);
    ConsoleWriteLn(Console, 'Text in Yellow');
    ConsoleTextColor(Console, tcLIGHTRED);
    ConsoleWriteLn(Console, 'Text in LightRed');
    ConsoleTextColor(Console, tcLIGHTGREEN);
    ConsoleWriteLn(Console, 'Text in LightGreen');
    ConsoleWrite(Console, 'press any key...');
    ConsoleReadKey(Console);
    ConsoleReset(Console);
    ConsoleWriteLn(Console, 'Normal settings again, and screen restored.');
    ConsoleWrite(Console, 'press any key...');
    ConsoleReadKey(Console);
  finally
    DeleteConsole(Console);
  end;
end.
