unit IConsoleDLL;

interface

type
  TTextColor = (
    tcBLACK,
    tcBLUE,
    tcGREEN,
    tcCYAN,
    tcRED,
    tcMAGENTA,
    tcBROWN,
    tcLIGHTGRAY,
    tcDARKGRAY,
    tcLIGHTBLUE,
    tcLIGHTGREEN,
    tcLIGHTCYAN,
    tcLIGHTRED,
    tcLIGHTMAGENTA,
    tcYELLOW,
    tcWHITE
  );

  IConsole = interface
  ['{9BBDA1A4-21E7-4D11-8F1C-E2AD13D2779C}']
    procedure Reset; stdcall;
    procedure ClearScreen; stdcall;
    procedure GotoXY(x, y : Integer); stdcall;
    procedure TextColor(newColor: TTextColor); stdcall;
    procedure TextAttribute(newAttribute: Integer); stdcall;
    procedure TextBackground(newBackground: TTextColor); stdcall;
    function ReadKey: Integer; stdcall;
    function KeyPressed: Boolean; stdcall;
    procedure Write(text: PAnsiChar); stdcall;
    procedure WriteLn(text: PAnsiChar); stdcall;
  end;

function CreateConsole: IConsole; safecall;

implementation

function CreateConsole; external 'IConsoleDLL.dll' name 'CreateConsole';

end.