#pragma once

/*                                                                          */
/*  File:      iconsole.h                                                   */
/*  Function:  IConsole interface declaration - demo for article            */
/*             http://rvelthuis.de/articles/articles-cppobjs.html           */
/*  Language:  C++ (C++Builder 2007)                                        */
/*  Author:    Rudy Velthuis                                                */
/*  Copyright: (c) 2012 Rudy Velthuis. All rights reserved.                 */
/*  Disclaimer:                                                             */
/*                                                                          */
/*    Redistribution and use in source and binary forms, with or            */
/*    without modification, are permitted provided that the following       */
/*    conditions are met:                                                   */
/*                                                                          */
/*    - Redistributions of source code must retain the above copyright      */
/*      notice, this list of conditions and the following disclaimer.       */
/*    - Redistributions in binary form must reproduce the above copyright   */
/*      notice, this list of conditions and the following disclaimer in	    */
/*      the documentation and/or other materials provided with the          */
/*      distribution.                                                       */
/*    - Neither the name of this code nor the names of its                  */
/*      contributors may be used to endorse or promote products derived	    */
/*      from this software without specific prior written permission.       */
/*                                                                          */
/*    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND                */
/*    CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,           */
/*    INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF              */
/*    MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE                  */
/*    ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR	            */
/*    CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,          */
/*    SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,              */
/*    BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;      */
/*    LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER      */
/*    CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT    */
/*    LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING        */
/*    IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF        */
/*    THE POSSIBILITY OF SUCH DAMAGE.                                       */
/*                                                                          */

#include <windows.h>
#include <System.hpp>
#include "console.h"

struct __declspec(uuid("{9BBDA1A4-21E7-4D11-8F1C-E2AD13D2779C}"))
    IConsole : public IUnknown
{
public:
    virtual void __stdcall Reset() = 0;
    virtual void __stdcall ClearScreen() = 0;
    virtual void __stdcall GotoXY(int x, int y) = 0;
    virtual void __stdcall TextColor(TextColors newColor) = 0;
    virtual void __stdcall TextAttribute(int newAttribute) = 0;
    virtual void __stdcall TextBackground(int newBackground) = 0;
    virtual int __stdcall ReadKey() = 0;
    virtual bool __stdcall KeyPressed() = 0;
    virtual void __stdcall Write(const char *text) = 0;
    virtual void __stdcall WriteLn(const char *text) = 0;
};

typedef System::DelphiInterface<IConsole> _di_IConsole;

#ifdef ICONSOLEDLL_EXPORT
#define ICONSOLEDLL_API __declspec(dllexport) __stdcall
#else
#define ICONSOLEDLL_API __declspec(dllimport) __stdcall
#endif

extern "C" HRESULT ICONSOLEDLL_API CreateConsole(IConsole **console);

