#pragma once

/*                                                                          */
/*  File:      tconsole.h                                                   */
/*  Function:  IConsole interface implementation - demo for article         */
/*             http://rvelthuis.de/articles/articles-cppobjs.html           */
/*  Language:  C++ (C++Builder 2007)                                        */
/*  Author:    Rudy Velthuis                                                */
/*  Copyright: (c) 2012 Rudy Velthuis. All rights reserved.                 */
/*  Disclaimer:                                                             */
/*                                                                          */
/*    Redistribution and use in source and binary forms, with or            */
/*    without modification, are permitted provided that the following       */
/*    conditions are met:                                                   */
/*                                                                          */
/*    - Redistributions of source code must retain the above copyright      */
/*      notice, this list of conditions and the following disclaimer.       */
/*    - Redistributions in binary form must reproduce the above copyright   */
/*      notice, this list of conditions and the following disclaimer in     */
/*      the documentation and/or other materials provided with the          */
/*      distribution.                                                       */
/*    - Neither the name of this code nor the names of its                  */
/*      contributors may be used to endorse or promote products derived	    */
/*      from this software without specific prior written permission.       */
/*                                                                          */
/*    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND                */
/*    CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,           */
/*    INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF              */
/*    MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE                  */
/*    ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR             */
/*    CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,          */
/*    SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,              */
/*    BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;      */
/*    LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER      */
/*    CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT    */
/*    LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING        */
/*    IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF        */
/*    THE POSSIBILITY OF SUCH DAMAGE.                                       */
/*                                                                          */

#include "iconsole.h"
#include "console.h"
#include <stdio.h>

class TConsole : public TInterfacedObject, IConsole
{
public:

    __fastcall TConsole() : FConsole() { }

    virtual __fastcall ~TConsole() { }

    // Methods of IConsole wrapping Console

    void __stdcall Reset()
    {
        FConsole.reset();
    }

    void __stdcall ClearScreen()
    {
        FConsole.clearScreen();
    }

    void __stdcall GotoXY(int x, int y)
    {
        FConsole.gotoXY(x, y);
    }

    void __stdcall TextColor(TextColors newColor)
    {
        FConsole.textColor(newColor);
    }

    void __stdcall TextAttribute(int newAttribute)
    {
        FConsole.textAttribute(newAttribute);
    }

    void __stdcall TextBackground(int newBackground)
    {
        FConsole.textBackground(newBackground);
    }

    int __stdcall ReadKey()
    {
        return FConsole.readKey();
    }

    bool __stdcall KeyPressed()
    {
        return FConsole.keyPressed();
    }

    void __stdcall Write(const char *text)
    {
        FConsole.write(text);
    }

    void __stdcall WriteLn(const char *text)
    {
        FConsole.writeLn(text);
    }

    // Methods of IInterface/IUnknown have to be reimplemented and forwarded.

    HRESULT __stdcall QueryInterface(REFIID riid, void **ppvObject)
    {
        return GetInterface(riid, ppvObject) ? S_OK : E_NOINTERFACE;
    }

    ULONG __stdcall AddRef()
    {
        return TInterfacedObject::_AddRef();
    }

    ULONG __stdcall Release()
    {
        return TInterfacedObject::_Release();
    }

private:
    Console FConsole;

};

