/*                                                                          */              
/*  File:      console.cpp                                                  */
/*  Function:  Simple console functionality - demo for article              */
/*             http://rvelthuis.de/articles/articles-cppobjs.html           */
/*  Language:  C++ (Visual C++ 2010)                                        */
/*  Author:    Rudy Velthuis                                                */
/*  Copyright: (c) 2012 Rudy Velthuis. All rights reserved.                 */
/*  Disclaimer:                                                             */
/*                                                                          */
/*    Redistribution and use in source and binary forms, with or            */
/*    without modification, are permitted provided that the following       */
/*    conditions are met:                                                   */
/*                                                                          */
/*    - Redistributions of source code must retain the above copyright      */
/*      notice, this list of conditions and the following disclaimer.       */
/*    - Redistributions in binary form must reproduce the above copyright   */
/*      notice, this list of conditions and the following disclaimer in	    */
/*      the documentation and/or other materials provided with the          */
/*      distribution.                                                       */
/*    - Neither the name of this code nor the names of its                  */
/*      contributors may be used to endorse or promote products derived	    */
/*      from this software without specific prior written permission.       */
/*                                                                          */
/*    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND                */
/*    CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,           */
/*    INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF              */
/*    MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE                  */
/*    ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR	            */
/*    CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,          */
/*    SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,              */
/*    BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;      */
/*    LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER      */
/*    CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT    */
/*    LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING        */
/*    IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF        */
/*    THE POSSIBILITY OF SUCH DAMAGE.                                       */
/*                                                                          */

#undef UNICODE

#include "stdafx.h"
#include "console.h"
#include <conio.h>		// for _getch(), _kbhit() and _cputs()

Console::Console(void)
{
	hConsole = GetStdHandle(STD_OUTPUT_HANDLE);
	COORD bufferCoord = { 0, 0 };

	memset(&oldState, sizeof(oldState), 0);
	GetConsoleScreenBufferInfo(hConsole, &oldState);
	textAttr = oldState.wAttributes;

	screenBuffer = new CHAR_INFO[oldState.dwSize.X * oldState.dwSize.Y];
    ReadConsoleOutputA(hConsole, screenBuffer, oldState.dwSize, bufferCoord, &oldState.srWindow); 
}

Console::~Console(void)
{
    reset();
	delete[] screenBuffer;
}

void Console::reset(void)
{
	COORD bufferCoord = { 0, 0 };

    textAttribute(oldState.wAttributes);
    clearScreen();
    WriteConsoleOutputA(hConsole, screenBuffer, oldState.dwSize, bufferCoord, &oldState.srWindow);
    gotoXY(oldState.dwCursorPosition.X, oldState.dwCursorPosition.Y);
}

void Console::clearScreen(void)
{
	COORD writeCoord = { 0, 0 };
	DWORD charsWritten;

    FillConsoleOutputCharacterA(hConsole, ' ', oldState.dwSize.X * oldState.dwSize.Y, writeCoord, &charsWritten);
	FillConsoleOutputAttribute(hConsole, textAttr, oldState.dwSize.X * oldState.dwSize.Y, writeCoord, &charsWritten);
	gotoXY(0, 0);
}

void Console::gotoXY(int x, int y)
{
	COORD cursorPos;

	cursorPos.X = (SHORT)x;
	cursorPos.Y = (SHORT)y;
    
	SetConsoleCursorPosition(hConsole, cursorPos);
}

void Console::textColor(TextColors newColor)
{
	textAttribute((textAttr & 0xFFF0) | (newColor & 0x0F));
}

void Console::textAttribute(int newAttribute)
{
    SetConsoleTextAttribute(hConsole, (WORD)newAttribute);
	textAttr = (WORD)newAttribute;
}

void Console::textBackground(int newBackground)
{
    textAttribute((textAttr & 0xFF0F) | ((newBackground & 0x000F) << 4));
}

// Note: Glad that the VC++ conio.h has at least these functions. 
//       They are not so easy to implement.

int Console::readKey(void)
{
    return _getch();
}

bool Console::keyPressed(void)
{
    return (_kbhit() != 0);
}

void Console::write(const char *text)
{
    _cputs(text);
}

void Console::writeLn(const char *text)
{
    write(text);
    write("\r\n");
}


