/*                                                                          */
/*  File:      console.cpp                                                  */
/*  Function:  Console implementation - demo for article                    */
/*             http://rvelthuis.de/articles/articles-cppobjs.html           */
/*  Language:  C++ (C++Builder 2007)                                        */
/*  Author:    Rudy Velthuis                                                */
/*  Copyright: (c) 2012 Rudy Velthuis. All rights reserved.                 */
/*  Disclaimer:                                                             */
/*                                                                          */
/*    Redistribution and use in source and binary forms, with or            */
/*    without modification, are permitted provided that the following       */
/*    conditions are met:                                                   */
/*                                                                          */
/*    - Redistributions of source code must retain the above copyright      */
/*      notice, this list of conditions and the following disclaimer.       */
/*    - Redistributions in binary form must reproduce the above copyright   */
/*      notice, this list of conditions and the following disclaimer in	    */
/*      the documentation and/or other materials provided with the          */
/*      distribution.                                                       */
/*    - Neither the name of this code nor the names of its                  */
/*      contributors may be used to endorse or promote products derived	    */
/*      from this software without specific prior written permission.       */
/*                                                                          */
/*    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND                */
/*    CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,           */
/*    INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF              */
/*    MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE                  */
/*    ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR	            */
/*    CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,          */
/*    SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,              */
/*    BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;      */
/*    LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER      */
/*    CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT    */
/*    LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING        */
/*    IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF        */
/*    THE POSSIBILITY OF SUCH DAMAGE.                                       */
/*                                                                          */

#pragma hdrstop

#include "console.h"
#include <conio.h>

Console::Console(void)
{
    ::gettextinfo(&oldState);
    screenBuffer = new char[oldState.screenheight * oldState.screenwidth * 2];
    ::gettext(1, 1, oldState.screenwidth, oldState.screenheight, screenBuffer);
}

Console::~Console(void)
{
    reset();
}

void Console::reset(void)
{
    ::window(oldState.winleft, oldState.wintop,
        oldState.winright, oldState.winbottom);
    textAttribute(oldState.attribute);
    clearScreen();
    ::puttext(1, 1, oldState.screenwidth, oldState.screenheight, screenBuffer);
    gotoXY(oldState.curx, oldState.cury);
}

void Console::clearScreen(void)
{
    ::clrscr();
}

void Console::gotoXY(int x, int y)
{
    ::gotoxy(x, y);
}

void Console::textColor(TextColors newColor)
{
    ::textcolor(newColor);
}

void Console::textAttribute(int newAttribute)
{
    ::textattr(newAttribute);
}

void Console::textBackground(int newBackground)
{
    ::textbackground(newBackground);
}

int Console::readKey(void)
{
    return ::getch();
}

bool Console::keyPressed(void)
{
    return (::kbhit() != 0);
}

void Console::write(const char *text)
{
    ::cputs(text);
}

void Console::writeLn(const char *text)
{
    write(text);
    write("\r\n");
}


