#ifndef _CONSOLE_H
#define _CONSOLE_H

/*                                                                          */
/*  File:      console.h                                                    */
/*  Function:  Simple console class declarations - demo for article         */
/*             http://rvelthuis.de/articles/articles-cppobjs.html           */
/*  Language:  C++ (C++Builder 2007)                                        */
/*  Author:    Rudy Velthuis                                                */
/*  Copyright: (c) 2012 Rudy Velthuis. All rights reserved.                 */
/*  Disclaimer:                                                             */
/*                                                                          */
/*    Redistribution and use in source and binary forms, with or            */
/*    without modification, are permitted provided that the following       */
/*    conditions are met:                                                   */
/*                                                                          */
/*    - Redistributions of source code must retain the above copyright      */
/*      notice, this list of conditions and the following disclaimer.       */
/*    - Redistributions in binary form must reproduce the above copyright   */
/*      notice, this list of conditions and the following disclaimer in	    */
/*      the documentation and/or other materials provided with the          */
/*      distribution.                                                       */
/*    - Neither the name of this code nor the names of its                  */
/*      contributors may be used to endorse or promote products derived	    */
/*      from this software without specific prior written permission.       */
/*                                                                          */
/*    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND                */
/*    CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,           */
/*    INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF              */
/*    MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE                  */
/*    ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR             */
/*    CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,          */
/*    SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,              */
/*    BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;      */
/*    LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER      */
/*    CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT    */
/*    LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING        */
/*    IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF        */
/*    THE POSSIBILITY OF SUCH DAMAGE.                                       */
/*                                                                          */

#pragma once
#pragma hdrstop

#include <conio.h>      // for text_info

enum TextColors
{
    tcBLACK,
    tcBLUE,
    tcGREEN,
    tcCYAN,
    tcRED,
    tcMAGENTA,
    tcBROWN,
    tcLIGHTGRAY,
    tcDARKGRAY,
    tcLIGHTBLUE,
    tcLIGHTGREEN,
    tcLIGHTCYAN,
    tcLIGHTRED,
    tcLIGHTMAGENTA,
    tcYELLOW,
    tcWHITE
};

class Console
{
public:
    Console(void);
    virtual ~Console(void);
    void reset(void);
    void clearScreen(void);
    void gotoXY(int x, int y);
    void textColor(TextColors newColor);
    void textAttribute(int newAttribute);
    void textBackground(int newBackground);
    int readKey(void);
    bool keyPressed(void);
    void write(const char *text);
    void writeLn(const char *text);

private:
    text_info oldState;
    char *screenBuffer;
};

#endif