{                                                                           }
{ File:       IntegerLists.pas                                              }
{ Function:   Very simple class wrapping integer array.                     }
{ Language:   Delphi                                                        }
{ Author:     Rudy Velthuis                                                 }
{ Copyright:  (c) 2003,2004 Rudy Velthuis                                   }
{ Disclaimer: This code is freeware. All rights are reserved.               }
{             This code is provided as is, expressly without a warranty     }
{             of any kind. You use it at your own risk.                     }
{                                                                           }
{             If you use this code, please credit me.                       }
{                                                                           }

unit IntegerLists;

interface

type
  TIntegerArray = array of Integer;

  TIntegerList = class
  private
    FArray: TIntegerArray;
    FCount: Integer;
    function GetIntegers(Index: Integer): Integer;
    procedure SetIntegers(Index: Integer; const Value: Integer);
    procedure CheckIndex(Index: Integer);
  public
    constructor Create(Size: Integer = 2);
    constructor CreateFrom(IntArray: array of Integer);
    function Add(AInt: Integer): Integer;
    function AsArray: TIntegerArray;
    procedure Clear;
    property Count: Integer read FCount;
    property Integers[Index: Integer]: Integer read GetIntegers write SetIntegers; default;
  end;

implementation

uses
  SysUtils;

{ TIntegerList }

function TIntegerList.Add(AInt: Integer): Integer;
var
  Capacity: Integer;
begin
  Capacity := Length(FArray);
  if FCount = Capacity then
  begin
    if Capacity < 2 then
      Capacity := 2;
    SetLength(FArray, 2 * Capacity);
  end;
  FArray[FCount] := AInt;
  Result := FCount;
  Inc(FCount);
end;

function TIntegerList.AsArray: TIntegerArray;
begin
  Result := Copy(FArray, 0, FCount);
end;

procedure TIntegerList.Clear;
begin
  SetLength(FArray, 2);
  FCount := 0;
end;

constructor TIntegerList.Create(Size: Integer);
begin
  SetLength(FArray, Size);
  FCount := 0;
end;

constructor TIntegerList.CreateFrom(IntArray: array of Integer);
var
  I: Integer;
begin
  SetLength(FArray, Length(IntArray));
  for I := 0 to High(IntArray) do
    FArray[I] := IntArray[I];
  FCount := Length(FArray);
end;

function TIntegerList.GetIntegers(Index: Integer): Integer;
begin
  CheckIndex(Index);
  Result := FArray[Index]
end;

procedure TIntegerList.SetIntegers(Index: Integer; const Value: Integer);
begin
  CheckIndex(Index);
  FArray[Index] := Value;
end;

procedure TIntegerList.CheckIndex(Index: Integer);
begin
  if (Index < 0) or (Index >= FCount) then
    raise Exception.CreateFmt('Index %d out of bounds (0-%d)',
      [Index, FCount - 1]);
end;

end.

