{                                                                           }
{ File:       TestIntLists.dpr                                              }
{ Function:   Simple demo for IntegerLists.pas                              }
{ Language:   Delphi                                                        }
{ Author:     Rudy Velthuis                                                 }
{ Copyright:  (c) 2003,2004 Rudy Velthuis                                   }
{ Disclaimer: This code is freeware. All rights are reserved.               }
{             This code is provided as is, expressly without a warranty     }
{             of any kind. You use it at your own risk.                     }
{                                                                           }
{             If you use this code, please credit me.                       }
{                                                                           }
program TestIntLists;

{$APPTYPE CONSOLE}

uses
  SysUtils,
  IntegerLists in 'IntegerLists.pas';

const
  A1: array[0..9] of Integer = (1, 3, 5, 7, 9, 13, 4, 12, 99, 17);

procedure WriteArray(Arr: array of Integer);
var
  I: Integer;
begin
  Write('(');
  for I := 0 to High(Arr) - 1 do
    Write(Arr[I], ' ');
  Writeln(Arr[High(Arr)], ')');
end;

procedure Test;
var
  I: Integer;
  A2: TIntegerArray;
  L: TIntegerList;
begin
  Randomize;
  WriteArray(A1);

  // Create from existing array
  L := TIntegerList.CreateFrom(A1);

  // Add a few items
  for I := 1 to 10 do
    L.Add(Random(1000) + 100);

  // copy to an array
  A2 := L.AsArray;
  WriteArray(A2);

  // Access like an array
  L[11] := 1234567;
  WriteArray(L.AsArray);

  // Access out of bounds
  // Note: I know, I know, a try except like this is bad practice.
  try
    L[22] := 1234;
  except
    on E: Exception do
      Writeln('Error: ', E.Message);
  end;
end;

begin
  Test;
  Readln;
end.

