
{*******************************************************}
{                                                       }
{       Borland Delphi Runtime Library                  }
{       Internet Shortcut interface definitions.        }
{                                                       }
{       Copyright (C) 1999 Rudolph Velthuis             }
{       Converted 27 May 1999 by R. Velthuis            }
{       Last update 27 May 1999 by R. Velthuis          }
{                                                       }
{*******************************************************}

unit IntShCut;

interface

{$HPPEMIT ''}
{$HPPEMIT '#include <isguids.h>'}
{$HPPEMIT '#include <intshcut.h>'}
{$HPPEMIT ''} 

uses
  Windows;

const 
  {$EXTERNALSYM CLSID_InternetShortcut}
  CLSID_InternetShortcut: TGUID = (
    D1: $FBF23B40; D2: $E3F0; D3: $101B; D4: ($84, $88, $00, $AA, $00, $3E, $56, $F8)); 
 
  {$EXTERNALSYM IID_IUniformResourceLocatorA}
  IID_IUniformResourceLocatorA: TGUID = (
    D1: $FBF23B80; D2: $E3F0; D3: $101B; D4: ($84, $88, $00, $AA, $00, $3E, $56, $F8)); 
  {$EXTERNALSYM IID_IUniformResourceLocatorW}
  IID_IUniformResourceLocatorW: TGUID = (
    D1: $CABB0DA0; D2: $DA57; D3: $11CF; D4: ($99, $74, $00, $20, $AF, $D7, $97, $62)); 
  {$EXTERNALSYM IID_IUniformResourceLocator}
  IID_IUniformResourceLocator: TGUID = (
    D1: $FBF23B80; D2: $E3F0; D3: $101B; D4: ($84, $88, $00, $AA, $00, $3E, $56, $F8)); 
 
{ HRESULTs } 

const 

// The flag combination is invalid. 
  E_FLAGS                     = SEVERITY_ERROR shl 31 or FACILITY_ITF shl 16 or $1000; 
 
// The URL's protocol handler failed to run. 
  {$EXTERNALSYM IS_E_EXEC_FAILED}
  IS_E_EXEC_FAILED            = SEVERITY_ERROR shl 31 or FACILITY_ITF shl 16 or $2002; 
 
// The URL's syntax is invalid. 
  {$EXTERNALSYM URL_E_INVALID_SYNTAX}
  URL_E_INVALID_SYNTAX        = SEVERITY_ERROR shl 31 or FACILITY_ITF shl 16 or $1001; 
 
// The URL's protocol does not have a registered protocol handler. 
  {$EXTERNALSYM URL_E_UNREGISTERED_PROTOCOL}
  URL_E_UNREGISTERED_PROTOCOL = SEVERITY_ERROR shl 31 or FACILITY_ITF shl 16 or $1002; 

 
// Input flags for IUniformResourceLocator::SetURL(). 

  {$EXTERNALSYM IURL_SETURL_FL_GUESS_PROTOCOL}
  IURL_SETURL_FL_GUESS_PROTOCOL          = $0001;     // Guess protocol if missing 
  {$EXTERNALSYM IURL_SETURL_FL_USE_DEFAULT_PROTOCOL}
  IURL_SETURL_FL_USE_DEFAULT_PROTOCOL    = $0002;     // Use default protocol if missing 


// Input flags for IUniformResourceLocator()::InvokeCommand(). 

  {$EXTERNALSYM IURL_INVOKECOMMAND_FL_ALLOW_UI}
  IURL_INVOKECOMMAND_FL_ALLOW_UI         = $0001; 
  {$EXTERNALSYM IURL_INVOKECOMMAND_FL_USE_DEFAULT_VERB}
  IURL_INVOKECOMMAND_FL_USE_DEFAULT_VERB = $0002;     // Ignore pcszVerb 
 
type
  {$EXTERNALSYM IURL_SETURL_FLAGS}
  IURL_SETURL_FLAGS = DWORD; 
  TIUrlSetUrlFlags = DWORD;
  {$EXTERNALSYM IURL_INVOKECOMMAND_FLAGS}
  IURL_INVOKECOMMAND_FLAGS = DWORD; 
  TIUrlInvokeCommandFlags = DWORD;
  
  
// Command info for IUniformResourceLocator::InvokeCommand(). 

type
  PUrlInvokeCommandInfoA = ^TUrlInvokeCommandInfoA;
  {$EXTERNALSYM URLINVOKECOMMANDINFOA}
  URLINVOKECOMMANDINFOA = packed record
    dwcbSize: DWORD;      // Size of structure 
    dwFlags: DWORD;       // Bit field of IURL_INVOKECOMMAND_FLAGS 
    hwndParent: HWND;     // Parent window.  Valid only if IURL_INVOKECOMMAND_FL_ALLOW_UI is set. 
    pcszVerb: PAnsiChar;  // Verb to invoke.  Ignored if IURL_INVOKECOMMAND_FL_USE_DEFAULT_VERB is set. 
  end;
  TUrlInvokeCommandInfoA = URLINVOKECOMMANDINFOA;
  PUrlInvokeCommandInfoW = ^TUrlInvokeCommandInfoW;
  {$EXTERNALSYM URLINVOKECOMMANDINFOW}
  URLINVOKECOMMANDINFOW = packed record
    dwcbSize: DWORD;      // Size of structure 
    dwFlags: DWORD;       // Bit field of IURL_INVOKECOMMAND_FLAGS 
    hwndParent: HWND;     // Parent window.  Valid only if IURL_INVOKECOMMAND_FL_ALLOW_UI is set. 
    pcszVerb: PWideChar;  // Verb to invoke.  Ignored if IURL_INVOKECOMMAND_FL_USE_DEFAULT_VERB is set. 
  end;
  TUrlInvokeCommandInfoW = URLINVOKECOMMANDINFOW;
  PUrlInvokeCommandInfo = PUrlInvokeCommandInfoA;
 
 
//=========================================================================== 
// 
// IUniformResourceLocator interface 
// 
// [OverView] 
// 
//  Provides access to Internet Shortcuts. 
// 
// [Member functions] 
// 
// IUniformResourceLocator::SetURL 
// 
//   This member function sets an object's URL. 
// 
//   The dwInFlags parameter specifies the behavior: 
// 
//  IURL_SETURL_FL_GUESS_PROTOCOL: The protocol scheme is guessed and added 
//   to the URL, if it is not specified in pcszURL. 
// 
//  IURL_SETURL_FL_USE_DEFAULT_PROTOCOL: The default protocol scheme is added 
//   to the URL, if it is not specified in pcszURL. 
// 
//   The function returns S_OK if the object's URL is set successfully. 
//  Otherwise, an error code is returned: 
// 
//  E_OUTOFMEMORY:  There is not enough memory to complete the operation. 
// 
//  IS_E_EXEC_FAILED:  The URL's protocol handler failed to run. 
// 
//  URL_E_INVALID_SYNTAX:  The URL's syntax is invalid. 
// 
//  URL_E_UNREGISTERED_PROTOCOL:  The URL's protocol does not have a 
//   registered protocol handler. 
// 
// 
// IUniformResourceLocator::GetURL 
// 
//   This member function retrieves an object's URL.  The ppszURL is a 
//  pointer to a PSTR to be filled in which a pointer to the object's 
//  URL.  When finished, this string should be freed using IMalloc::Free(). 
// 
//   The function returns S_OK if the object's URL was retrieved 
//  successfully.  If the object does not have a URL associated with it, 
//  then S_FALSE is returned and *ppszURL is set to NULL.  Otherwise, an 
//  error code is returned: 
// 
//  E_OUTOFMEMORY:  There is not enough memory to complete the operation. 
// 
//  IS_E_EXEC_FAILED:  The URL's protocol handler failed to run. 
// 
//  URL_E_INVALID_SYNTAX:  The URL's syntax is invalid. 
// 
//  URL_E_UNREGISTERED_PROTOCOL:  The URL's protocol does not have a 
//   registered protocol handler. 
// 
// 
// IUniformResourceLocator::InvokeCommand 
// 
//   This member function invokes a command on an object's URL.  The purlici 
//  parameter is a pointer to a URLINVOKECOMMANDINFO structure which 
//  describes the command to be invoked. 
// 
//   The function returns S_OK if the object's URL was opened successfully. 
//  If the object does not have a URL associated with it, the function 
//  returns S_FALSE.  Otherwise, an error code is returned: 
// 
//  E_OUTOFMEMORY:  There is not enough memory to complete the operation. 
// 
//  IS_E_EXEC_FAILED:  The URL's protocol handler failed to run. 
// 
//  URL_E_INVALID_SYNTAX:  The URL's syntax is invalid. 
// 
//  URL_E_UNREGISTERED_PROTOCOL:  The URL's protocol does not have a 
//   registered protocol handler. 
// 
//=========================================================================== 
 
{$EXTERNALSYM IUniformResourceLocatorA}
IUniformResourceLocatorA = interface(IUnknown) 
  function SetUrl(pcszUrl: PAnsiChar; dwInFlags: DWORD): HResult; stdcall;
  function GetUrl(out ppszUrl: PAnsiChar): HResult; stdcall;
  function InvokeCommand(purlici: PUrlInvokeCommandInfoA): HResult; stdcall;
end; 
{$EXTERNALSYM IUniformResourceLocatorW}
IUniformResourceLocatorW = interface(IUnknown) 
  function SetUrl(pcszUrl: PWideChar; dwInFlags: DWORD): HResult; stdcall;
  function GetUrl(out ppszUrl: PWideChar): HResult; stdcall;
  function InvokeCommand(purlici: PUrlInvokeCommandInfoW): HResult; stdcall;
end; 
  {$EXTERNALSYM IUniformResourceLocator}
  IUniformResourceLocator = IUniformResourceLocatorA;
 
const  
// Input flags for TranslateURL(). 
  {$EXTERNALSYM TRANSLATEURL_FL_GUESS_PROTOCOL}
  TRANSLATEURL_FL_GUESS_PROTOCOL         = $0001;     // Guess protocol if missing 
  {$EXTERNALSYM TRANSLATEURL_FL_USE_DEFAULT_PROTOCOL}
  TRANSLATEURL_FL_USE_DEFAULT_PROTOCOL   = $0002;     // Use default protocol if missing 

type
  {$EXTERNALSYM TRANSLATEURL_IN_FLAGS}
  TRANSLATEURL_IN_FLAGS = DWORD;
  TTranslateUrlInFlags = DWord;
 
 
//   TranslateURL().  This function applies common translations to a URL 
//  string, creating a new URL string. 
// 
//   This function does not perform any validation on the syntax of the input 
//  URL string.  A successful return value does not indicate that the input 
//  or output URL strings are valid URLS. 
// 
//   The function returns S_OK if the URL string is translated successfully 
//  and *ppszTranslatedURL points to the translated URL string.  S_FALSE 
//  is returned if the URL string did not require translation.  An error 
//  code is returned if an error occurs. 
// 
//  Parameters: 
//   pcszURL -- A pointer to the URL string to be translated. 
//   dwInFlags -- A bit field of TRANSLATEURL_IN_FLAGS. 
//   ppszTranslatedURL -- A pointer to the newly created, translated URL 
//     string, if any.  *ppszTranslatedURL is only valid if S_OK is returned. 
//     If valid, *ppszTranslatedURL should be freed by calling LocalFree(). 
//     *ppszTranslatedURL is NULL on error. 

{$EXTERNALSYM TranslateURLA}
function TranslateURLA(pcszURL: PAnsiChar; dwInFlags: DWORD;
  out ppszTranslatedUR: PAnsiChar): HResult; stdcall;
{$EXTERNALSYM TranslateURLW}
function TranslateURLW(pcszURL: PWideChar; dwInFlags: DWORD;
  out ppszTranslatedUR: PWideChar): HResult; stdcall;
{$EXTERNALSYM TranslateURL}
function TranslateURL(pcszURL: PChar; dwInFlags: DWORD;
  out ppszTranslatedUR: PChar): HResult; stdcall;
 
 
// Input flags for URLAssociationDialog(). 
const
  {$EXTERNALSYM URLASSOCDLG_FL_USE_DEFAULT_NAME}
  URLASSOCDLG_FL_USE_DEFAULT_NAME  = $0001; 
  {$EXTERNALSYM URLASSOCDLG_FL_REGISTER_ASSOC}
  URLASSOCDLG_FL_REGISTER_ASSOC    = $0002; 
 
type
  {$EXTERNALSYM URLASSOCIATIONDIALOG_IN_FLAGS}
  URLASSOCIATIONDIALOG_IN_FLAGS = DWORD;
  TUrlAssociationDialogInFlags = DWord; 
 
 
//   URLAssocationDialog().  This function invokes the unregistered URL 
//  protocol dialog box, providing a standard ui for choosing the handler for 
//  an unregistered URL protocol. 
// 
//  The functions returns S_OK if the application is registered with the 
//  URL protocol.  S_FALSE is returned if nothing is registered (a one-time 
//  execution via the selected application is requested). 
// 
//  Parameters: 
//   hwndParent -- A handle to the window to be used as the parent 
//   dwInFlags -- A bit field of URLASSOCIATIONDIALOG_IN_FLAGS.  The 
//                flags are: 
// 
//                  URLASSOCDLG_FL_USE_DEFAULT_NAME: Use the default Internet 
//                   Shortcut file name.  Ignore pcszFile. 
// 
//                  URLASSOCDLG_FL_REGISTER_ASSOC: The application 
//                   selected is to be registered as the handler for URLs 
//                   of pcszURL's protocol.  An application is only 
//                   registered if this flag is set, and the user indicates 
//                   that a persistent association is to be made. 
// 
//   pcszFile -- The name of the Internet Shortcut file whose URL's protocol 
//               requires a protocol handler.  Before a verb, like "open", can 
//               be invoked on an Internet Shortcut, a protocol handler must be 
//               registered for its URL protocol.  If 
//               URLASSOCDLG_FL_USE_DEFAULT_NAME is set in dwInFlags, pcszFile 
//               is ignored, and a default Internet Shortcut file name is used. 
//               pcszFile is only used for ui. 
//   pcszURL -- The URL whose unregistered protocol requires a handler. 
//   pszAppBuf -- A buffer to be filled in on success with the path 
//                of the application selected by the user.  pszAppBuf's 
//                buffer is filled in with the empty string on failure. 
//   ucAppBufLen -- The length of pszAppBuf's buffer in characters. 
// 
 
{$EXTERNALSYM URLAssociationDialogA}
function URLAssociationDialogA(hwndParent: HWND; dwInFlags: DWORD; pcszFile, 
  pcszURL: PAnsiChar; pszAppBuf: PAnsiChar; ucAppBufLen: UINT): HResult; stdcall;
{$EXTERNALSYM URLAssociationDialogW}
function URLAssociationDialogW(hwndParent: HWND; dwInFlags: DWORD; pcszFile, 
  pcszURL: PWideChar; pszAppBuf: PWideChar; ucAppBufLen: UINT): HResult; stdcall;
{$EXTERNALSYM URLAssociationDialog}
function URLAssociationDialog(hwndParent: HWND; dwInFlags: DWORD; pcszFile, 
  pcszURL: PChar; pszAppBuf: PChar; ucAppBufLen: UINT): HResult; stdcall;
 
 
// Input flags for MIMEAssocationDialog(). 
const
  {$EXTERNALSYM MIMEASSOCDLG_FL_REGISTER_ASSOC}
  MIMEASSOCDLG_FL_REGISTER_ASSOC = $0001; 
 
type 
  {$EXTERNALSYM MIMEASSOCIATIONDIALOG_IN_FLAGS}
  MIMEASSOCIATIONDIALOG_IN_FLAGS = DWORD;
  TMimeAssociationDialogInFlags = DWORD;
 
 
// 
//   MIMEAssociationDialog().  Invokes the unregistered MIME content 
//  type dialog box. 
// 
//   This function does not perform any validation on the syntax of the 
//  input content type string.  A successful return value does not indicate 
//  that the input MIME content type string is a valid content type. 
// 
//   The function returns S_OK if the MIME content type is associated 
//  with the extension.  The extension is associated as the default 
//  extension for the content type.  S_FALSE is returned if nothing is 
//  registered.  Otherwise, the function returns one of the following 
//  errors: 
// 
//  E_ABORT -- The user cancelled the operation. 
//  E_FLAGS -- The flag combination passed in dwFlags is invalid. 
//  E_OUTOFMEMORY -- Not enough memory to complete the operation. 
//  E_POINTER -- One of the input pointers is invalid. 
// 
//  Parameters: 
//   hwndParent -- A handle to the window to be used as the parent 
//                 window of any posted child windows. 
//   dwInFlags -- A bit field of MIMEASSOCIATIONDIALOG_IN_FLAGS.  The 
//                flags are: 
// 
//              MIMEASSOCDLG_FL_REGISTER_ASSOC: If set, the application 
//               selected is to be registered as the handler for files of 
//               the given MIME type.  If clear, no association is to be 
//               registered.  An application is only registered if this 
//               flag is set, and the user indicates that a persistent 
//               association is to be made.  Registration is only possible 
//               if pcszFile contains an extension. 
// 
//   pcszFile -- A pointer to a string indicating the name of the file 
//               containing data of pcszMIMEContentType's content type. 
//   pcszMIMEContentType -- A pointer to a string indicating the content 
//                          type for which an application is sought. 
//   pszAppBuf -- A buffer to be filled in on success with the path of 
//                the application selected by the user.  pszAppBuf's buffer 
//                is filled in with the empty string on failure. 
//   ucAppBufLen -- The length of pszAppBuf's buffer in characters. 
// 
 
{$EXTERNALSYM MIMEAssociationDialogA}
function MIMEAssociationDialogA(hwndParent: HWND; dwInFlags: DWORD; pcszFile, 
  pcszMIMEContentType: PAnsiChar; pszAppBuf: PAnsiChar; ucAppBufLen: UINT): HResult; stdcall;
{$EXTERNALSYM MIMEAssociationDialogW}
function MIMEAssociationDialogW(hwndParent: HWND; dwInFlags: DWORD; pcszFile, 
  pcszMIMEContentType: PWideChar; pszAppBuf: PWideChar; ucAppBufLen: UINT): HResult; stdcall;
{$EXTERNALSYM MIMEAssociationDialog}
function MIMEAssociationDialog(hwndParent: HWND; dwInFlags: DWORD; pcszFile, 
  pcszMIMEContentType: PChar; pszAppBuf: PChar; ucAppBufLen: UINT): HResult; stdcall;

//   InetIsOffline().  This function determines if the user wants to be 
//  "offline" (get all information from the cache).  The dwFlags must be 
//  0. 
// 
//   The function returns TRUE to indicate that the local system is not 
//  currently connected to the Internet.  The function returns FALSE to 
//  indicate that either the local system is connected to the Internet, 
//  or no attempt has yet been made to connect the local system to the 
//  Internet.  Applications that wish to support an off-line mode should 
//  do so if InetIsOffline() returns TRUE. 
// 
//   Off-line mode begins when the user has been prompted to dial-in to 
//  an Internet providor, but canceled the attempt. 
// 
{$EXTERNALSYM InetIsOffline}
function InetIsOffline(dwFlags: DWORD): BOOL; stdcall;

implementation

const
  shdocvwdll = 'shdocvw.dll';
  
function TranslateURLA; external shdocvwdll name 'TranslateURLA';
function TranslateURLW; external shdocvwdll name 'TranslateURLW';
function TranslateURL; external shdocvwdll name 'TranslateURLA';
function URLAssociationDialogA; external shdocvwdll name 'URLAssociationDialogA';
function URLAssociationDialogW; external shdocvwdll name 'URLAssociationDialogW';
function URLAssociationDialog; external shdocvwdll name 'URLAssociationDialogA';
function MIMEAssociationDialogA; external shdocvwdll name 'MIMEAssociationDialogA';
function MIMEAssociationDialogW; external shdocvwdll name 'MIMEAssociationDialogW';
function MIMEAssociationDialog; external shdocvwdll name 'MIMEAssociationDialogA';
function InetIsOffline; external shdocvwdll name 'InetIsOffline';

end.
