unit PosProcs;

interface

uses
  System.SysUtils;

// TBytes
function RVPosExB(const Needle, Haystack: TBytes; Offset: Integer = 0): Integer;

// Ansi
function PosUModForA(const Needle, Haystack: AnsiString; Offset: Integer): Integer;
function OrgPosA(const Needle, Haystack: AnsiString; Offset: Integer): Integer;
function RVPosExA(const Needle, Haystack: AnsiString; Offset: Integer = 1): Integer;

// Unicode
function RVPosExU(const Needle, Haystack: UnicodeString; Offset: Integer = 1): Integer;

implementation

// My (RV's) implementation for byte arrays.
function RVPosExB(const Needle, Haystack: TBytes; Offset: Integer = 0): Integer;
type
  PUInt32 = ^UInt32;
  PUInt16 = ^UInt16;
var
  LNeedleTip: UInt32;
  LNeedleTip2: Byte;
  PNeedle: PByte;
  PHaystack, PEnd: PByte;
  LLenNeedle: Integer;
  LCmpMemOffset: Integer;
begin
  if Offset - 1 + Length(Needle) > Length(Haystack) then
    Exit(0);
  Result := 0;
  PHaystack := PByte(Haystack) + Offset;
  PEnd := PHaystack + Length(Haystack) - Length(Needle) + 1;
  case Length(Needle) of
    0: Exit(0);
    1:
      begin
        LNeedleTip := PByte(Needle)^;
        while PHaystack < PEnd do
         if PByte(PHaystack)^ = LNeedleTip then
           Exit(PHaystack - PByte(Haystack))
         else
           Inc(PHaystack);
        Exit(0);
      end;
    2:
      begin
        LNeedleTip := PUInt16(Needle)^;
        while PHaystack < PEnd do
          if PUInt16(Haystack)^ = LNeedleTip then
            Exit(PHaystack - PByte(Haystack))
          else
            Inc(PHaystack);
        Exit(0);
      end;
    3:
      begin
        LNeedleTip := PUInt16(Needle)^;
        LNeedleTip2 := PByte(Needle)[2];
        while PHayStack < PEnd do
          if (PUInt16(PHaystack)^ = LNeedleTip) and (PHaystack[2] = LNeedleTip2) then
            Exit(PHaystack - PByte(Haystack))
          else
            Inc(PHaystack);
        Exit(0);
      end;
    4:
      begin
        LNeedleTip := PUInt32(Needle)^; // if Needle is length 3, then top byte is the #0 terminator
        while PHaystack < PEnd do
          if PUInt32(Haystack)^ = LNeedleTip then
            Exit(PHaystack - PByte(Haystack))
          else
            Inc(PHaystack);
        Exit(0);
      end;
    else
      begin
        LCmpMemOffset := SizeOf(UInt32) div SizeOf(AnsiChar);
        PNeedle := PByte(Needle) + LCmpMemOffset;
        LLenNeedle := Length(Needle) - LCmpMemOffset;
        LNeedleTip := PUInt32(Needle)^;
        while PHaystack < PEnd do
          if (PUInt32(PHaystack)^ = LNeedleTip) and CompareMem(PHaystack + LCmpMemOffset, PNeedle, LLenNeedle) then
            Exit(PHaystack - PByte(Haystack) + 1)
          else
            Inc(PHaystack);
      end;
  end;
end;

// Copy of original Pos(UnicodeString), but now for AnsiString.
function PosUModForA(const Needle, Haystack: AnsiString; Offset: Integer): Integer; overload;
var
  I, LIterCnt, L, J: Integer;
  PNeedle, PS: PAnsiChar;
  LCh: AnsiChar;
begin
  PNeedle := Pointer(Needle);
  PS := Pointer(Haystack);
  if (PNeedle = nil) or (PS = nil) or (Offset < 1) then
    Exit(0);
  L := Length(Needle);
  { Calculate the number of possible iterations. }
  LIterCnt := Length(Haystack) - Offset - L + 2;
  if (L > 0) and (LIterCnt > 0) then
  begin
    Inc(PS, Offset - 1);
    I := 0;
    LCh := PNeedle[0];
    if L = 1 then   // Special case when Substring length is 1
      repeat
        if PS[I] = LCh then
          Exit(I + Offset);
        Inc(I);
      until I = LIterCnt
    else
      repeat
        if PS[I] = LCh then
        begin
          J := 1;
          repeat
            if PS[I + J] = PNeedle[J] then
            begin
              Inc(J);
              if J = L then
                Exit(I + Offset);
            end
            else
              Break;
          until False;
        end;
        Inc(I);
      until I = LIterCnt;
  end;
  Result := 0;
end;

// Copy of original Pos(AnsiString) from System.pas, for WIN64 target.
// Note that this is NOT the same code as that for Pos(UnicodeString), WIN64 target.
function OrgPosA(const Needle, Haystack: AnsiString; Offset: Integer): Integer;
var
  I, LIterCnt, L, J: Integer;
  PNeedle, PHaystack: PAnsiChar;
begin
  L := Length(Needle);
  { Calculate the number of possible iterations. Not valid if Offset < 1. }
  LIterCnt := Length(Haystack) - Offset - L + 1;

  { Only continue if the number of iterations is positive or zero (there is space to check) }
  if (Offset > 0) and (LIterCnt >= 0) and (L > 0) then
  begin
    PNeedle := PAnsiChar(Needle);
    PHaystack := PAnsiChar(Haystack);
    Inc(PHaystack, Offset - 1);

    for I := 0 to LIterCnt do
    begin
      J := 0;
      while (J >= 0) and (J < L) do
      begin
        if PHaystack[I + J] = PNeedle[J] then
          Inc(J)
        else
          J := -1;
      end;
      if J >= L then
        Exit(I + Offset);
    end;
  end;

  Result := 0;
end;

// My (RV's) implementation of PosEx for AnsiStrings.
function RVPosExA(const Needle, Haystack: AnsiString; Offset: Integer = 1): Integer;
type
  PUInt32 = ^UInt32;
  PUInt16 = ^UInt16;
{$IFNDEF CPU32BITS}
var
  LNeedleTip: UInt32;
  PNeedle: PAnsiChar;
  PHaystack, PEnd: PAnsiChar;
  LLenNeedle: Integer;
  LCmpMemOffset: Integer;
{$ENDIF}
begin
{$IFDEF CPU32BITS}
  Result := System.Pos(Needle, Haystack, Offset); // FastCode (asm) implementation in WIN32.
{$ELSE}
  if Offset - 1 + Length(Needle) > Length(Haystack) then
    Exit(0);
  Result := 0;
  PHaystack := PAnsiChar(Haystack) + Offset - 1;
  PEnd := PHaystack + Length(Haystack) - Length(Needle) + 1;
  case Length(Needle) of
    0: Exit(0);
    1:
      begin
        LNeedleTip := PByte(Needle)^;
        while PHaystack < PEnd do
         if PByte(PHaystack)^ = LNeedleTip then
           Exit(PHaystack - PAnsiChar(Haystack) + 1)
         else
           Inc(PHaystack);
        Exit(0);
      end;
    2:
      begin
        LNeedleTip := PUInt16(Needle)^;
        while PHaystack < PEnd do
          if PUInt16(Haystack)^ = LNeedleTip then
            Exit(PHayStack - PAnsiChar(Haystack) + 1)
          else
            Inc(PHaystack);
        Exit(0);
      end;
    3:
      begin
        LNeedleTip := PUInt32(Needle)^; // if Needle is length 3, then top byte is the #0 terminator
        while PHaystack < PEnd do
          if ((PUInt32(Haystack)^ xor LNeedleTip) and $FFFFFF) = 0 then
            Exit(PHaystack - PAnsiChar(Haystack) + 1)
          else
            Inc(PHaystack);
        Exit(0);
      end;
    4:
      begin
        LNeedleTip := PUInt32(Needle)^; // if Needle is length 3, then top byte is the #0 terminator
        while PHaystack < PEnd do
          if PUInt32(Haystack)^ = LNeedleTip then
            Exit(PHaystack - PAnsiChar(Haystack) + 1)
          else
            Inc(PHaystack);
        Exit(0);
      end;
    else
      begin
        LCmpMemOffset := SizeOf(UInt32) div SizeOf(AnsiChar);
        PNeedle := PAnsiChar(Needle) + LCmpMemOffset;
        LLenNeedle := Length(Needle) - LCmpMemOffset;
        LNeedleTip := PUInt32(Needle)^;
        while PHaystack < PEnd do
          if (PUInt32(PHaystack)^ = LNeedleTip) and CompareMem(PHaystack + LCmpMemOffset, PNeedle, LLenNeedle) then
            Exit(PHaystack - PAnsiChar(Haystack) + 1)
          else
            Inc(PHaystack);
      end;
  end;
{$ENDIF}
end;

// My (RV's) implementation of PosEx for UnicodeString.
function RVPosExU(const Needle, Haystack: UnicodeString; Offset: Integer = 1): Integer;
type
  PUInt32 = ^UInt32;
  PUInt16 = ^UInt16;
{$IFNDEF CPU32BITS}
var
  LNeedleTip: UInt32;
  PNeedle: PWideChar;
  PHaystack, PEnd: PWideChar;
  LLenNeedle: Integer;
  LCmpMemOffset: Integer;
{$ENDIF}
begin
{$IFDEF CPU32BITS}
  Result := System.Pos(Needle, Haystack, Offset); // FastCode (asm) implementation in WIN32.
{$ELSE}
  if Offset - 1 + Length(Needle) > Length(Haystack) then
    Exit(0);
  Result := 0;
  PHaystack := PWideChar(Haystack) + Offset - 1;
  PEnd := PHaystack + Length(Haystack) - Length(Needle) + 1;
  case Length(Needle) of
    0: Exit(0);
    1:
      begin
        LNeedleTip := PUInt16(Needle)^;
        while PHaystack < PEnd do
         if PUInt16(PHaystack)^ = LNeedleTip then
           Exit(PHaystack - PWideChar(Haystack) + 1)
         else
           Inc(PHaystack);
        Exit(0);
      end;
    2:
      begin
        LNeedleTip := PUInt32(Needle)^;
        while PHaystack < PEnd do
          if PUInt32(Haystack)^ = LNeedleTip then
            Exit(PHayStack - PWideChar(Haystack) + 1)
          else
            Inc(PHaystack);
        Exit(0);
      end;
    else
      begin
        LCmpMemOffset := SizeOf(UInt32) div SizeOf(Char);
        PNeedle := PWideChar(Needle) + LCmpMemOffset;
        LLenNeedle := Length(Needle) - LCmpMemOffset;
        LNeedleTip := PUInt32(Needle)^;
        while PHaystack < PEnd do
          if (PUInt32(PHaystack)^ = LNeedleTip) and CompareMem(PHaystack + LCmpMemOffset, PNeedle, LLenNeedle * SizeOf(Char)) then
            Exit(PHaystack - PWideChar(Haystack) + 1)
          else
            Inc(PHaystack);
      end;
  end;
{$ENDIF}
end;



end.
