#include <vcl.h>
#pragma hdrstop

#include "FRadioDialTest.h"

#pragma package(smart_init)
#pragma link "RadioDial"
#pragma resource "*.dfm"

TForm1 *Form1;

__fastcall TForm1::TForm1(TComponent* Owner)
    : TForm(Owner)
{
   trkPointerSize->Max = rdlDemo->Max;
   trkPointerSize->Min = rdlDemo->Min;
   trkPointerSize->SelEnd = trkPointerSize->Max;
   trkPointerSize->SelStart = trkPointerSize->Max - rdlDemo->Position;
   rdlDemo->PointerSize = trkPointerSize->Max - trkPointerSize->Position;
}


void __fastcall TForm1::btnPointerShapeClick(TObject *Sender)
{
   TRadioPointerShape s = rdlDemo->PointerShape;
   switch (s)
   {
      case Radiodial::psLine: s = Radiodial::psTriangle; break;
      case Radiodial::psTriangle: s = Radiodial::psDot; break;
      case Radiodial::psDot: s = Radiodial::psOwnerDraw; break;
      case Radiodial::psOwnerDraw: s = Radiodial::psLine; break;
   }
   rdlDemo->PointerShape = s;
}


void __fastcall TForm1::rdlDemoDrawPointer(TCustomRadioDial *Sender,
      TRect ARect, TCanvas *ACanvas)
{
   // Draws arrow pointer, like this: --->
   TPoint p1, p2;

   // Move to center.
   // The pointer will be clipped by the pointer clip region, which is
   // dependent on rdlDemo->PointerSize.
   p1 = rdlDemo->Center;
   ACanvas->MoveTo(p1.x, p1.y);

   // Draw to edge of disk.
   p1 = rdlDemo->AngleToPoint(rdlDemo->Angle, rdlDemo->Center, rdlDemo->Radius - rdlDemo->ButtonEdge);
   ACanvas->LineTo(p1.x, p1.y);

   // Now take a left turn of 150 degrees and draw a line of length 20.
   p2 = rdlDemo->AngleToPoint(rdlDemo->Angle + 1500, p1, 20);
   ACanvas->LineTo(p2.x, p2.y);

   // Go back to tip, and turn right 150 degrees, drawing other half.
   ACanvas->MoveTo(p1.x, p1.y);
   p2 = rdlDemo->AngleToPoint(rdlDemo->Angle - 1500, p1, 20);
   ACanvas->LineTo(p2.x, p2.y);
}


void __fastcall TForm1::rdlDemoChange(TObject *Sender)
{
   trkPointerSize->SelStart = rdlDemo->Max - rdlDemo->Position;
   trkPointerSize->SelEnd = rdlDemo->Max;
}


void __fastcall TForm1::trkPointerSizeChange(TObject *Sender)
{
   rdlDemo->PointerSize = trkPointerSize->Max - trkPointerSize->Position;
}


void __fastcall TForm1::btnPointerColorClick(TObject *Sender)
{
   cdlgPointerColor->Color = rdlDemo->PointerColor;
   if (cdlgPointerColor->Execute())
      rdlDemo->PointerColor = cdlgPointerColor->Color;
}




